#cs ----------------------------------------------------------------------------

 Remmanaut, the autoit RMM tool

 Script function:		Management connector, communicates with the Remmanaut management tool
 Version:				0.2.3

 Author:				Faldo / Erik Ribbhammar
 UDF Credits:			lod3n (_RunReadStd), dantay9 (TCP File Transfer),
						Prog@ndy (MySQL, _TCPconnect), Greg Laabs (_http)
 Helping Credits:

#ce ----------------------------------------------------------------------------
#NoTrayIcon
#include <File.au3>
#include <Array.au3>
#include <Date.au3>
#include <mysql.au3>

;Predefined variables
Global $ListenIP = "0.0.0.0"
Global $MgmPort = IniRead ( "settings.ini", "variables", "MgmPort", "5075" )
Global $Recv, $RecvArray, $MySQLSession


;Start TCP server
TCPStartup()
$Listen = TCPListen($ListenIP, $MgmPort)
If @error Or $Listen = '-1' Then
	Exit _FileWriteLog(@ScriptDir & "\log.txt", "Unable to start management connector, exiting...")
Else
	_FileWriteLog(@ScriptDir & "\log.txt", "Management connector listening on port "&$MgmPort)
EndIf


While 1
	;Wait for agent to open a session
	Do
		$Client = TCPAccept($Listen)
		Sleep('100')
	Until $Client <> '-1'

	;Wait for agent to send a message
	For $i = 1 to 10
		$Recv = TCPRecv($Client, '1000')
		Sleep('100')
		If $Recv <> '' then ExitLoop
	Next

	;Split message from agent into header och payload
	$RecvArray = StringSplit($Recv, "|")

	;----------------------------
	;Mgm requesting list of agents
	If $RecvArray[1] = "agent_inv" Then
		_Open_MySql("remmanaut")

		;Select all agents from DB
		$query = "SELECT * FROM agents;"
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		If $SQL_Result = 0 then
			$result = _MySQL_Store_Result($MySQLSession)
			$array = _MySQL_Fetch_Result_StringArray($result)

			;If there are agents in DB reply to mgm with list
			If IsArray($array) Then
				$AgentList = ""
				For $i = 1 to UBound($array)-1
					$AgentList &= $array[$i][0]&"|"&$array[$i][1]&"|"&$array[$i][2]&"|"&$array[$i][3]&"|"&$array[$i][4]&"|"&$array[$i][5]&"|"&$array[$i][6]&"|"
				Next
				TCPSend($Client, $AgentList)
			Else
				TCPSend($Client, "No agents")
			EndIf

			_MySQL_Free_Result($result)
		Else
			_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while selecting: "& _MySQL_Error($MysqlSession))
		EndIf
		_Close_MySql()
	EndIf

	;Mgm requesting schedule of specific agent
	If $RecvArray[1] = "agent_shed" Then
		_Open_MySql("remmanaut")

		;Read queued actions for agent
		$query = "SELECT * FROM action_queue WHERE agent_id="&$RecvArray[2]&";"
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		If $SQL_Result = 0 then
			$result = _MySQL_Store_Result($MySQLSession)
			$array = _MySQL_Fetch_Result_StringArray($result)

			;If there are agents in DB reply to mgm with list
			If IsArray($array) Then
				$AgentShed = ""
				For $i = 1 to UBound($array)-1
					$AgentShed &= $array[$i][2]&"|"&$array[$i][3]&"|"&$array[$i][4]&"|"
				Next
				TCPSend($Client, $AgentShed)
			Else
				TCPSend($Client, "nothing scheduled")
			EndIf

			_MySQL_Free_Result($result)
		Else
			_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while selecting: "& _MySQL_Error($MysqlSession))
		EndIf
		_Close_MySql()
	EndIf

	;Mgm scheduling shell command for agent
	If $RecvArray[1] = "cmd_sysuser" Then
		$cmd_filtered = StringReplace($RecvArray[4], "\", "\\")
		_Open_MySql("remmanaut")
		$query =	'INSERT INTO action_queue (agent_id,schedule,action,parameter1,parameter2,parameter3,parameter4,parameter5) VALUES (' & _
					'"'&$RecvArray[2]&'","'&$RecvArray[3]&'","cmd_sysuser","'&$cmd_filtered&'","-i","1","null","null");'
		$SQL_Result = _MySQL_Real_Query($MySQLSession, $query)
		If $SQL_Result <> 0 then _FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while scheduling command: "& _MySQL_Error($MysqlSession))
		_Close_MySql()
		TCPSend($Client, $SQL_Result)
	EndIf

WEnd

TCPCloseSocket($Client)
TCPShutdown()
Exit


; Functions -----------------------------------------------------

Func _Open_MySQL($DB)
	;Initiate MySql library
	_MySQL_InitLibrary()
	If @error Then _FileWriteLog(@ScriptDir & "\log.txt", "Error initiating MySQL")

	;Initiate MySQL connection and connect to root
	$MySQLSession = _MySQL_Init()
	$Connection = _MySQL_Real_Connect($MysqlSession,"localhost","root","")
	If $Connection = 0 Then
		$errno = _MySQL_errno($MysqlSession)
		_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error while selecting: "& _MySQL_Error($MysqlSession))
		If $errno = $CR_UNKNOWN_HOST Then _FileWriteLog(@ScriptDir & "\log.txt", "Error:","$CR_UNKNOWN_HOST" & @LF & $CR_UNKNOWN_HOST)
	Endif

	;Select databse for Use
	$SQL_Return = _MySQL_Real_Query($MysqlSession, "USE "&$DB)
	If $SQL_Return <> 0 then
		_FileWriteLog(@ScriptDir & "\log.txt", "MySQL error: "& _MySQL_Error($MysqlSession))
	EndIf
EndFunc

Func _Close_MySql()
	;Close the MySql session
	_MySQL_Close($MysqlSession)
	;Close the MySql library
	_MySQL_EndLibrary()
EndFunc
